% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSexp2P.R
\name{SSexp2P}
\alias{SSexp2P}
\title{Self-Starting Nls 'exp2P' Regression Model}
\usage{
SSexp2P(predictor, a, b)
}
\arguments{
\item{predictor}{a numeric vector of values at which to evaluate the model.}

\item{a, b}{The numeric parameters responsing to the exp2P model.}
}
\description{
This selfStart model evaluates the power regression function (formula as: y=a*exp(b*x)). It has an initial attribute that will evaluate initial estimates of the parameters 'a' and 'b' for a given set of data.
}
\examples{
library(basicTrendline)
x<-1:5
y<-c(2,4,8,20,25)
xy<-data.frame(x,y)
getInitial(y ~ SSexp2P(x,a,b), data = xy)
## Initial values are in fact the converged values

fitexp2P <- nls(y~SSexp2P(x,a,b), data=xy)
summary(fitexp2P)

}
\seealso{
\code{\link{trendline}}, \code{\link{SSexp3P}}, \code{\link{SSpower3P}}, \code{\link[stats]{nls}}, \code{\link[stats]{selfStart}}
}
\author{
Weiping Mei \email{meiweipingg@163.com}
}
