% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_bases.R
\name{count_bases}
\alias{count_bases}
\title{Count the number of A's, C's, G's, and T's in a DNA sequence}
\usage{
count_bases(sequence)
}
\arguments{
\item{sequence}{a character string containing a DNA sequence}
}
\value{
a named integer vector containing the counts of A's, C's, G's, and T's
}
\description{
This function takes a single argument, a DNA sequence as a character string,
and counts the number of A's, C's, G's, and T's in the sequence. The counts
are returned as a named vector.
}
\examples{
sequence <- "ATCGAGCTAGCTAGCTAGCTAGCT"
count_bases(sequence)
# A  C  G  T
# 6  6  6  6
}
