% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_player_game_stats_current.R
\name{mlb_player_game_stats_current}
\alias{mlb_player_game_stats_current}
\title{\strong{Find MLB Player Game Stats - Current Game}}
\usage{
mlb_player_game_stats_current(person_id = NULL)
}
\arguments{
\item{person_id}{MLBAMIDs for player of interest.}
}
\value{
Returns a tibble with the following columns:\tabular{ll}{
   col_name \tab types \cr
   type \tab character \cr
   group \tab character \cr
   stat_assists \tab integer \cr
   stat_put_outs \tab integer \cr
   stat_errors \tab integer \cr
   stat_chances \tab integer \cr
   stat_fielding \tab character \cr
   stat_caught_stealing \tab integer \cr
   stat_passed_ball \tab integer \cr
   stat_stolen_bases \tab integer \cr
   stat_stolen_base_percentage \tab character \cr
   stat_pickoffs \tab integer \cr
   stat_games_played \tab integer \cr
   stat_games_started \tab integer \cr
   stat_fly_outs \tab integer \cr
   stat_ground_outs \tab integer \cr
   stat_air_outs \tab integer \cr
   stat_runs \tab integer \cr
   stat_doubles \tab integer \cr
   stat_triples \tab integer \cr
   stat_home_runs \tab integer \cr
   stat_strike_outs \tab integer \cr
   stat_base_on_balls \tab integer \cr
   stat_intentional_walks \tab integer \cr
   stat_hits \tab integer \cr
   stat_hit_by_pitch \tab integer \cr
   stat_at_bats \tab integer \cr
   stat_number_of_pitches \tab integer \cr
   stat_innings_pitched \tab character \cr
   stat_wins \tab integer \cr
   stat_losses \tab integer \cr
   stat_saves \tab integer \cr
   stat_save_opportunities \tab integer \cr
   stat_holds \tab integer \cr
   stat_blown_saves \tab integer \cr
   stat_earned_runs \tab integer \cr
   stat_batters_faced \tab integer \cr
   stat_outs \tab integer \cr
   stat_games_pitched \tab integer \cr
   stat_complete_games \tab integer \cr
   stat_shutouts \tab integer \cr
   stat_pitches_thrown \tab integer \cr
   stat_balls \tab integer \cr
   stat_strikes \tab integer \cr
   stat_strike_percentage \tab character \cr
   stat_hit_batsmen \tab integer \cr
   stat_balks \tab integer \cr
   stat_wild_pitches \tab integer \cr
   stat_rbi \tab integer \cr
   stat_games_finished \tab integer \cr
   stat_runs_scored_per9 \tab character \cr
   stat_home_runs_per9 \tab character \cr
   stat_inherited_runners \tab integer \cr
   stat_inherited_runners_scored \tab integer \cr
   stat_catchers_interference \tab integer \cr
   stat_sac_bunts \tab integer \cr
   stat_sac_flies \tab integer \cr
   stat_ground_into_double_play \tab integer \cr
   stat_ground_into_triple_play \tab integer \cr
   stat_plate_appearances \tab integer \cr
   stat_total_bases \tab integer \cr
   stat_left_on_base \tab integer \cr
   stat_at_bats_per_home_run \tab character \cr
   game_type \tab character \cr
   num_teams \tab integer \cr
   stat_avg \tab character \cr
   stat_obp \tab character \cr
   stat_slg \tab character \cr
   stat_ops \tab character \cr
   stat_outs_pitched \tab integer \cr
   stat_whip \tab character \cr
   stat_ground_outs_to_airouts \tab character \cr
   stat_pitches_per_inning \tab character \cr
   stat_strikeout_walk_ratio \tab character \cr
   stat_strikeouts_per9inn \tab character \cr
   stat_walks_per9inn \tab character \cr
   stat_hits_per9inn \tab character \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_link \tab character \cr
   opponent_id \tab integer \cr
   opponent_name \tab character \cr
   opponent_link \tab character \cr
   pitcher_id \tab integer \cr
   pitcher_full_name \tab character \cr
   pitcher_link \tab character \cr
   pitcher_first_name \tab character \cr
   pitcher_last_name \tab character \cr
   batter_id \tab integer \cr
   batter_full_name \tab character \cr
   batter_link \tab character \cr
   batter_first_name \tab character \cr
   batter_last_name \tab character \cr
   total_splits \tab integer \cr
   type_display_name \tab character \cr
   group_display_name \tab character \cr
   player_id \tab numeric \cr
   game_pk \tab numeric \cr
}
}
\description{
\strong{Find MLB Player Game Stats - Current Game}
}
\examples{
\donttest{
  try(mlb_player_game_stats_current(person_id = 660271))
}
}
