% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeList.R
\name{treeList}
\alias{treeList}
\title{Generate a List of Tree Structures from BART Model Output}
\usage{
treeList(trees, iter = NULL, treeNo = NULL)
}
\arguments{
\item{trees}{A dataframe that contains the tree structures generated by a BART model.
Expected columns include iteration, treeNum, parent, node, obsNode,}

\item{iter}{An integer specifying the iteration number of trees to be included in the output.
If NULL, trees from all iterations are included.}

\item{treeNo}{An integer specifying the number of the tree to include in the output.
If NULL, all trees are included.}
}
\value{
A list of tidygraph objects, each representing the structure of a tree. Each tidygraph object includes
        node and edge information necessary for visualisation.
}
\description{
This function takes a dataframe of trees, which is output from a BART model, and organizes
it into a list of tree structures. It allows for filtering based on iteration number, tree
number, and optionally reordering based on the maximum depth of nodes or variables.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 library(ggplot2)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6], df[, 1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 trees_list <- treeList(trees_data)
}

}
