% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim2Raster.R
\name{sim2Raster}
\alias{sim2Raster}
\title{sim2Raster: Convert a BAM simulation object to RasterStack}
\usage{
sim2Raster(sdm_simul, which_steps = NULL, progress_bar = TRUE)
}
\arguments{
\item{sdm_simul}{A bam object. See \code{\link[bamm]{sdm_sim}}}

\item{which_steps}{A numeric vector indicating the simulation steps that
are going to be converted into raster layers.}

\item{progress_bar}{Show progress bar}
}
\value{
A RasterStack of species' distribution at each simulation step
}
\description{
Convert a BAM simulation object to RasterStack.
}
\examples{
\donttest{
model_path <- system.file("extdata/Lepus_californicus_cont.tif",
                          package = "bamm")
model <- raster::raster(model_path)
sparse_mod <- bamm::model2sparse(model,threshold=0.1)
adj_mod <- bamm::adj_mat(sparse_mod,ngbs = 1)
occs_lep_cal <- data.frame(longitude = c(-115.10417,
                                         -104.90417),
                           latitude = c(29.61846,
                                        29.81846))
occs_sparse <- bamm::occs2sparse(modelsparse = sparse_mod,
                                occs = occs_lep_cal)
sdm_lep_cal <- bamm::sdm_sim(set_A = sparse_mod,
                            set_M = adj_mod,
                            initial_points = occs_sparse,
                            nsteps = 10)
sdm_lep_cal_st <- bamm::sim2Raster(sdm_simul = sdm_lep_cal,
                                  which_steps = seq(1,10,by=1))

raster::plot(sdm_lep_cal_st)

}
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
