% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-methods.R
\name{components.bage_mod}
\alias{components.bage_mod}
\title{Extract Values for Hyper-Parameters}
\usage{
\method{components}{bage_mod}(
  object,
  standardize = c("terms", "anova", "none"),
  quiet = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{bage_mod} object,
typically created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{standardize}{Standardization method:
one of \code{"terms"}, \code{"anova"}, or "none".
The default is \code{"terms"}.
See below for details.}

\item{quiet}{Whether to suppress messages.
Default is \code{FALSE}.}

\item{...}{Unused. Included for generic consistency only.}
}
\value{
A \link[tibble:tibble-package]{tibble}
with four columns columns:

The return value contains the following columns:
\itemize{
\item \code{term} Model term that the hyper-parameter belongs to.
\item \code{component} Component within term.
\item \code{level} Element within component .
\item \code{.fitted} An \link[rvec:rvec]{rvec} containing
draws from the posterior distribution.
}
}
\description{
Extract values for hyper-parameters
from a model object. Hyper-parameters include
main effects and interactions,
dispersion and variance terms,
and SVD or spline coefficients.
}
\section{Fitted vs unfitted models}{


\code{components()} is typically called on a \link[=fit]{fitted}
model. In this case, the modelled values are
draws from the joint posterior distribution for the
hyper-parameters in the model.

\code{components()} can, however, be called on an
unfitted model. In this case, the modelled values
are draws from the joint prior distribution.
In other words, the modelled values are informed by
model priors, and by any \code{exposure}, \code{size}, or \code{weights}
argument in the model, but not by the observed outcomes.
}

\section{Standardizing estimates}{


Often the sum of the intercept, main effect,
and interaction terms is well-identified by the data, but
the values for individual terms is not. This indeterminancy
does not affect the ultimate estimation of rates,
probabilities, and means, but does complicate the
interpretation of the higher-level terms.

One way of dealing with poorly-
identified terms is to post-process the estimates,
imposing some sort of standardization. There are
three options, specified through the \code{standardize}
argument:
\itemize{
\item \code{"terms"} Each main effect or interaction,
and any component terms such as trend or
seasonal effects, are independently scaled
so that they sum to 0.
\item \code{"anova"} An ANOVA-style decomposition is
carried out so that all variation associated
with age is attributed to the age term,
all variation associated with the interaction
between age and sex is attributed to the
age-sex term, and so on. Components terms
such as trend and seasonal effects are left untouched.
\item \code{"none"} No standardization is done.
}

\code{"terms"} standardization is helpful for understanding
model dynamics. \code{"anova"} standardization is helpful
for understanding the contribution of each variable
to overall patterns.

For a description of the standardization
algorithms used by \strong{bage},
see \code{vignette("vig2_math")}.
}

\examples{
## specify model
mod <- mod_pois(injuries ~ age + sex + year,
                data = injuries,
                exposure = popn)

## extract prior distribution
## of hyper-parameters
mod |>
  components()

## fit model
mod <- mod |>
  fit()

## extract posterior distribution
## of hyper-parameters
mod |>
  components()
}
\seealso{
\itemize{
\item \code{\link[=augment]{augment()}} Extract data and values for rates,
means, or probabilities
\item \code{\link[=tidy]{tidy()}} Extract a one-line summary of a model
\item \code{\link[=mod_pois]{mod_pois()}} Specify a Poisson model
\item \code{\link[=mod_binom]{mod_binom()}} Specify a binomial model
\item \code{\link[=mod_norm]{mod_norm()}} Specify a normal model
\item \code{\link[=fit]{fit()}} Fit a model
\item \code{\link[=is_fitted]{is_fitted()}} See if a model has been fitted
\item \code{\link[=unfit]{unfit()}} Reset a model
}
}
