% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badges.R
\name{badge_projectstatus}
\alias{badge_projectstatus}
\title{Add project status badge}
\usage{
badge_projectstatus(status = "concept")
}
\arguments{
\item{status}{one of concept, wip, suspended, abandoned, active, inactive, unsupported, or moved}
}
\value{
markdown
}
\description{
Project-status is based on the repo-status project on \url{https://www.repostatus.org/}.
A project-status badge gives a clear indication of the current state of a project. This
helps answer questions about development (whether or not further development is planned)
and support (whether bugfixes and user assistance will be given).
}
\section{Project Statuses}{

The following list is a literal copy of repostatus.org
\itemize{
\item Concept – Minimal or no implementation has been done yet, or the repository is only intended to be a limited example, demo, or proof-of-concept.
\item WIP – Initial development is in progress, but there has not yet been a stable, usable release suitable for the public.
\item Suspended – Initial development has started, but there has not yet been a stable, usable release; work has been stopped for the time being but the author(s) intend on resuming work.
\item Abandoned – Initial development has started, but there has not yet been a stable, usable release; the project has been abandoned and the author(s) do not intend on continuing development.
\item Active – The project has reached a stable, usable state and is being actively developed.
\item Inactive – The project has reached a stable, usable state but is no longer being actively developed; support/maintenance will be provided as time allows.
\item Unsupported – The project has reached a stable, usable state but the author(s) have ceased all work on it. A new maintainer may be desired.
\item Moved - The project has been moved to a new location, and the version at that location should be considered authoritative. This status should be accompanied by a new URL.
}
}

\examples{
badge_projectstatus("unsupported")
}
\seealso{
Other badges: \code{\link{badge_codecov}},
  \code{\link{badge_cran_ago}},
  \code{\link{badge_cran_date}},
  \code{\link{badge_cran_version_ago}},
  \code{\link{badge_cran_version_release}},
  \code{\link{badge_cran}},
  \code{\link{badge_github_fork}},
  \code{\link{badge_github_star}},
  \code{\link{badge_last_change_static}},
  \code{\link{badge_last_change}},
  \code{\link{badge_license}},
  \code{\link{badge_minimal_r_version}},
  \code{\link{badge_packageversion}},
  \code{\link{badge_rank}},
  \code{\link{badge_rdocumentation}},
  \code{\link{badge_thanks_md}}, \code{\link{badge_travis}}
}
\concept{badges}
