% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.narrative.R
\name{write.narrative}
\alias{write.narrative}
\title{Generates suggested manuscript text}
\usage{
write.narrative(
  agents,
  artifacts,
  weighted,
  bipartite,
  symmetric,
  signed,
  mtc,
  alpha,
  s,
  ut,
  lt,
  trials,
  model,
  retained
)
}
\arguments{
\item{agents}{integer: number of agents in a bipartite graph, or nodes in a unipartite graph}

\item{artifacts}{integer: number of artifacts in a bipartite graph}

\item{weighted}{boolean: TRUE if input graph was weighted}

\item{bipartite}{boolean: TRUE if input graph was bipartite}

\item{symmetric}{boolean: TRUE if input graph was symmetric}

\item{signed}{boolean: TRUE if a signed backbone was requested}

\item{mtc}{string: type of multiple test correction}

\item{alpha}{numeric: alpha significance threshold (used in statistical models)}

\item{s}{numeric: sparsification parameter (used in sparsification models)}

\item{ut}{numeric: upper threshold (used in global threshold)}

\item{lt}{numeric: lower threshold (used in global threshold)}

\item{model}{string: name of backbone null model}

\item{retained}{numeric: percent of edges retained in the backbone}

\item{trials:}{integer: number of trials used to estimate FDSM or oSDSM p-values}
}
\value{
NULL; only displays text in the console
}
\description{
\code{write.narrative} displays suggested text and references that can be used in a manuscript to describe the extracted backbone
}
\keyword{internal}
