% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2ListFileNames.R
\name{b2ListFileNames}
\alias{b2ListFileNames}
\title{List B2 File Names.}
\usage{
b2ListFileNames(bucketId, startFileName = "", maxFileCount = 100)
}
\arguments{
\item{bucketId}{The unique identifier of the bucket containing the files to
be listed. Bucket IDs may be obtained through the
\code{b2ListBuckets}function in this package.}

\item{startFileName}{The name of the file from which the list will start.
This is an optional parameter. Not defining this parameter will result in
the list starting from the newest file first. File names may be obtained
through the \code{b2ListFileNames} function in this package.}

\item{maxFileCount}{An integer defining the maximum number of file names to
return. This is an optional parameter and defaults to 100. The maximum
acceptable value is 1000.}
}
\value{
If successful a list will be returned containing \code{files} and
  \code{nextFileName}, for files within the specified bucket. If greater than
  the maximum number of specified files in \code{maxFileCount} exists,
  further file names may be obtained beginning with \code{nextFileName}, as
  the \code{startFileName} parameter value. If successful a data frame will
  be returned, nested within \code{files}, containing \code{fileId},
  \code{fileName}, \code{action}, \code{size} and \code{uploadTimestamp} for
  all files within the specified bucket.
}
\description{
\code{b2ListFileNames} lists the names of all files in a bucket, starting at
a given name.
}
\details{
This function lists the names of all files in a bucket, starting at a given
name, within a user's account on the Backblaze B2 cloud storage product.
There may be many file versions for the same name, but this function will
return each name only once. If you want all of the versions, use
\code{b2ListFileVersions} instead. Further details regarding this API call
are available here:

\url{https://www.backblaze.com/b2/docs/b2_list_file_names.html}

\code{bucketId} is mandatory and must be user defined. \code{startFileName}
and \code{maxFileCount} are optional and may be defined by the user if so
desired.
}
\examples{
\dontrun{
b2ListFileNames(bucketId = "aUniqueBucketId",
startFileName = "yourFileName.png",
maxFileCount = 500)
}

}

