% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2DeleteFileVersion.R
\name{b2DeleteFileVersion}
\alias{b2DeleteFileVersion}
\title{Delete B2 File Version.}
\usage{
b2DeleteFileVersion(fileName, fileId)
}
\arguments{
\item{fileName}{The name of the file to be deleted. File names may be
obtained through the \code{b2ListFileNames} function in this package.}

\item{fileId}{The unique identifier of the file to be deleted. File IDs may
be obtained through the \code{b2UploadFile}, \code{b2ListFileNames}, or
\code{b2ListFileVersions} functions in this package.}
}
\value{
If successful a list containing the \code{fileId} and \code{fileName}
  will be echoed back to the user.
}
\description{
\code{b2DeleteFileVersion} deletes a version of a file in the user's account
on the Backblaze B2 cloud storage product.
}
\details{
This function deletes a version of a file within the user's account on the
Backblaze B2 cloud storage product. Files of the same name may have multiple
versions stored on B2. If the deleted file version is the latest, and there
are older versions of the same file, the most recent of these will become the
latest version. The most recent file version is always the version downloaded
if requested by name. Further details regarding this API call are available
here:

\url{https://www.backblaze.com/b2/docs/b2_delete_file_version.html}

\code{fileName} and \code{fileId} are mandatory and must be user defined.
}
\examples{
\dontrun{
b2DeleteFileVersion(fileName = "nameOfTheFileToDelete",
 fileId = "Unique_identifier_of_the_file_to_delete")
}

}

