% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotOcc.R
\name{plotOcc}
\alias{plotOcc}
\title{plotOcc}
\usage{
plotOcc(occ, regional = TRUE)
}
\arguments{
\item{occ}{dataTable of the species occurrence.}

\item{regional}{logical, whether the whole world should be plotted as the 
background or only the region adjacent to the species countries of 
occurrence.}
}
\value{
This function plots the species occurrence
}
\description{
Plot the species occurrences with map background for visualisation
}
\examples{

\donttest{
occ <- getOcc("Hemitriccus mirandae")

plotOcc(occ)

test_data <- data.frame(sps=rep("Equus acephalus",10),
             lon=c(-43.2,-58.4,-56,-44,-54.5,-57.4,-60.1,-68.5,-71.3,-47.5),
             lat=c(-22.9,-34.6,-34.8,-20,-25.5,-25.2,-3,-32.5,-41.1,-15.5),
             gender=rep("female",10),head_size=rep("headless individual"))

occ <- giveOcc(test_data,"sps","lon","lat")

plotOcc(occ)

# Plot occurrences with the whole world as background

plotOcc(occ,regional=FALSE)
}

}
