% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webservice-aci.R
\name{update_aci_webservice}
\alias{update_aci_webservice}
\title{Update a deployed ACI web service}
\usage{
update_aci_webservice(webservice, tags = NULL, properties = NULL,
  description = NULL, auth_enabled = NULL, ssl_enabled = NULL,
  ssl_cert_pem_file = NULL, ssl_key_pem_file = NULL,
  ssl_cname = NULL, enable_app_insights = NULL, models = NULL,
  inference_config = NULL)
}
\arguments{
\item{webservice}{The \code{AciWebservice} object.}

\item{tags}{A named list of key-value tags for the web service,
e.g. \code{list("key" = "value")}. Will replace existing tags.}

\item{properties}{A named list of key-value properties to add for the web
service, e.g. \code{list("key" = "value")}.}

\item{description}{A string of the description to give the web service.}

\item{auth_enabled}{If \code{TRUE} enable key-based authentication for the
web service.}

\item{ssl_enabled}{Whether or not to enable SSL for this Webservice.}

\item{ssl_cert_pem_file}{A string of the cert file needed if SSL is enabled.}

\item{ssl_key_pem_file}{A string of the key file needed if SSL is enabled.}

\item{ssl_cname}{A string of the cname if SSL is enabled.}

\item{enable_app_insights}{If \code{TRUE} enable AppInsights for the web service.}

\item{models}{A list of \code{Model} objects to package into the updated service.}

\item{inference_config}{An \code{InferenceConfig} object.}
}
\value{
None
}
\description{
Update an ACI web service with the provided properties. You can update the
web service to use a new model, a new entry script, or new dependencies
that can be specified in an inference configuration.

Values left as \code{NULL} will remain unchanged in the web service.
}
