% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{download_model}
\alias{download_model}
\title{Download a model to the local file system}
\usage{
download_model(model, target_dir = ".", exist_ok = FALSE)
}
\arguments{
\item{model}{The \code{Model} object.}

\item{target_dir}{A string of the path to the directory on your local
file system for where to download the model to. Defaults to ".".}

\item{exist_ok}{If \code{FALSE}, replace the downloaded folder/file if they
already exist.}
}
\value{
A string of the path to the file or folder of the downloaded
model.
}
\description{
Download a registered model to the \code{target_dir} of your local file
system.
}
\examples{
\dontrun{
ws <- load_workspace_from_config()
model <- get_model(ws, name = "my_model", version = 2)
download_model(model, target_dir = tempdir(), exist_ok = TRUE)
}
}
