% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messages.R
\name{send_msg}
\alias{send_msg}
\title{send_msg}
\usage{
send_msg(queue, msg, attributes = NULL, delay = NULL, query = NULL, ...)
}
\arguments{
\item{queue}{A character string containing a queue URL, or the name of the queue.}

\item{msg}{A character vector containing one or more message bodies.}

\item{attributes}{Currently ignored. (If \code{msg} is of length one, a specification of message attributes. Ignored otherwise.)}

\item{delay}{A numeric value indicating the number of seconds between 0 and 900 to delay a specific message. If \code{NULL}, the default value for the queue applies.}

\item{query}{A list specifying additional query arguments to be passed to the \code{query} argument of \code{\link{sqsHTTP}}.}

\item{...}{Additional arguments passed to \code{\link{sqsHTTP}}.}
}
\value{
A list of message information, including the MessageId and an MD5 checksum of the message body.
}
\description{
Send a message to an SQS queue
}
\examples{
\dontrun{
  # list current queues
  list_queues()
  
  # create a queue
  queue <- create_queue("ExampleQueue")
  get_queue_url("ExampleQueue")
  
  # send message to queue
  send_msg("ExampleQueue", "This is a test message")
  # receive a message
  (m <- receive_msg("ExampleQueue", timeout = 0))
  
  # delete a message from queue
  delete_msg("ExampleQueue", m$ReceiptHandle[1])
  
  # delete queue
  delete_queue("ExampleQueue")
  
}
}
\author{
Thomas J. Leeper
}
\references{
\href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html}{SendMessage}
\href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessageBatch.html}{SendMessageBatch}
}
\seealso{
\code{link{receive_msg}} \code{link{delete_msg}}
}

