% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_put_account_setting}
\alias{ecs_put_account_setting}
\title{Put Account Setting}
\usage{
ecs_put_account_setting(
  name = NULL,
  value = NULL,
  principalArn = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{name}{Character. The Amazon ECS resource name for which to modify the account setting.}

\item{value}{Character. The account setting value for the specified principal ARN.}

\item{principalArn}{Character. The ARN of the principal, which can be an IAM user, IAM role, or the root user.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Put Account Setting
}
\section{name}{

The Amazon ECS resource name for which to
modify the account setting. If \code{serviceLongArnFormat} is specified, the
ARN for your Amazon ECS services is affected. If \code{taskLongArnFormat} is
specified, the ARN and resource ID for your Amazon ECS tasks is
affected. If \code{containerInstanceLongArnFormat} is specified, the ARN and
resource ID for your Amazon ECS container instances is affected. If
\code{awsvpcTrunking} is specified, the elastic network interface (ENI) limit
for your Amazon ECS container instances is affected. If
\code{containerInsights} is specified, the default setting for CloudWatch
Container Insights for your clusters is
affected.
}

\section{value}{

The account setting value for the
specified principal ARN. Accepted values are \code{enabled} and
\code{disabled}.
}

\section{principalArn}{

The ARN of the principal, which can be
an IAM user, IAM role, or the root user. If you specify the root user,
it modifies the account setting for all IAM users, IAM roles, and the
root user of the account unless an IAM user or role explicitly overrides
these settings. If this field is omitted, the setting is changed only
for the authenticated user.
}

