% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_release_address}
\alias{ec2_release_address}
\title{Release Address}
\usage{
ec2_release_address(
  AllocationId = NULL,
  PublicIp = NULL,
  NetworkBorderGroup = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{AllocationId}{String. [EC2-VPC] The allocation ID. Required for EC2-VPC.[optional]}

\item{PublicIp}{String. [EC2-Classic] The Elastic IP address. Required for EC2-Classic.[optional]}

\item{NetworkBorderGroup}{String.   The set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses....[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Release Address
}
\section{AllocationId}{

[EC2-VPC] The allocation
ID. Required for EC2-VPC.
}

\section{PublicIp}{

[EC2-Classic] The
Elastic IP address. Required for EC2-Classic.
}

\section{NetworkBorderGroup}{


The set of Availability Zones, Local Zones, or Wavelength Zones from
which AWS advertises IP addresses.

If you provide an incorrect network border group, you will receive an
\code{InvalidAddress.NotFound} error. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html}{Error Codes}.

You cannot use a network border group with EC2 Classic. If you attempt
this operation on EC2 classic, you will receive an
\code{InvalidParameterCombination} error. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html}{Error Codes}.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

