% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_launch_template}
\alias{ec2_modify_launch_template}
\title{Modify Launch Template}
\usage{
ec2_modify_launch_template(
  DryRun = NULL,
  ClientToken = NULL,
  LaunchTemplateId = NULL,
  LaunchTemplateName = NULL,
  SetDefaultVersion = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{String.   Unique, case-sensitive identifier you provide to ensure the idempotency of the request.[optional]}

\item{LaunchTemplateId}{String. The ID of the launch template.[optional]}

\item{LaunchTemplateName}{String. The name of the launch template.[optional]}

\item{SetDefaultVersion}{String. The version number of the launch template to set as the default version.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modifies a launch template. You can specify which
version of the launch template to set as the default version. When
launching an instance, the default version applies when a launch
template version is not specified.
}
\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{


Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.

Constraint: Maximum 128 ASCII characters.
}

\section{LaunchTemplateId}{

The ID of the launch template. You must specify
either the launch template ID or launch template name in the
request.
}

\section{LaunchTemplateName}{

The name of the launch template. You must
specify either the launch template ID or launch template name in the
request.
}

\section{SetDefaultVersion}{

The version number of the launch template
to set as the default version.
}

