% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_launch_templates}
\alias{ec2_describe_launch_templates}
\title{Describe Launch Templates}
\usage{
ec2_describe_launch_templates(
  DryRun = NULL,
  LaunchTemplateId = NULL,
  LaunchTemplateName = NULL,
  Filter = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{LaunchTemplateId}{List. One or more launch template IDs.[optional]}

\item{LaunchTemplateName}{List. One or more launch template names.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more launch
templates.
}
\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{LaunchTemplateId}{

One or more launch template
IDs.
}

\section{LaunchTemplateName}{

One or more launch template
names.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{create-time} - The time the launch template was created.
\item \code{launch-template-name} - The name of the launch template.
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}
}

\section{MaxResults}{

The maximum number of results to return in
a single call. To retrieve the remaining results, make another call with
the returned \code{NextToken} value. This value can be between 1 and
200.
}

