% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_instance_type_offerings}
\alias{ec2_describe_instance_type_offerings}
\title{Describe Instance Type Offerings}
\usage{
ec2_describe_instance_type_offerings(
  DryRun = NULL,
  LocationType = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{LocationType}{String. The location type.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return for the request in a single page.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Returns a list of all instance types offered. The
results can be filtered by location (Region or Availability Zone). If no
location is specified, the instance types offered in the current Region
are returned.
}
\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{LocationType}{

The location
type.
}

\section{Filter}{


One or more filters. Filter names and values are case-sensitive.
\itemize{
\item \code{location} - This depends on the location type. For example, if the
location type is \code{region} (default), the location is the Region code
(for example, \code{us-east-2}.)
\item \code{instance-type} - The instance type. For example, \code{c5.2xlarge}.
}
}

\section{MaxResults}{

The maximum number of results to return for the
request in a single page. The remaining results can be seen by sending
another request with the next token value.
}

