% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_transit_gateway_route}
\alias{ec2_delete_transit_gateway_route}
\title{Delete Transit Gateway Route}
\usage{
ec2_delete_transit_gateway_route(
  TransitGatewayRouteTableId,
  DestinationCidrBlock,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayRouteTableId}{String. The ID of the transit gateway route table.}

\item{DestinationCidrBlock}{String. The CIDR range for the route. This must match the CIDR for the route exactly.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the specified route from the
specified transit gateway route table.
}
\section{TransitGatewayRouteTableId}{

The ID of the transit
gateway route table.
}

\section{DestinationCidrBlock}{

The CIDR range for the route.
This must match the CIDR for the route
exactly.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

