% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_vpn_connection}
\alias{ec2_create_vpn_connection}
\title{Create Vpn Connection}
\usage{
ec2_create_vpn_connection(
  CustomerGatewayId,
  Type,
  VpnGatewayId = NULL,
  TransitGatewayId = NULL,
  DryRun = NULL,
  Options = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{CustomerGatewayId}{String. The ID of the customer gateway.}

\item{Type}{String. The type of VPN connection (\code{ipsec.1}).}

\item{VpnGatewayId}{String. The ID of the virtual private gateway.[optional]}

\item{TransitGatewayId}{String. The ID of the transit gateway.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Options}{Object. The options for the VPN connection.[optional]}

\item{TagSpecification}{List. The tags to apply to the VPN connection.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Vpn Connection
}
\section{CustomerGatewayId}{

The ID of the customer
gateway.
}

\section{Type}{

The type of VPN connection
(\code{ipsec.1}).
}

\section{VpnGatewayId}{

The ID of the virtual private gateway.
If you specify a virtual private gateway, you cannot specify a transit
gateway.
}

\section{TransitGatewayId}{

The ID of the transit gateway. If you
specify a transit gateway, you cannot specify a virtual private
gateway.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Options}{

The options for the VPN
connection.
}

\section{TagSpecification}{

The tags to apply to the VPN
connection.
}

