% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_snapshots}
\alias{ec2_create_snapshots}
\title{Create Snapshots}
\usage{
ec2_create_snapshots(
  InstanceSpecification,
  Description = NULL,
  OutpostArn = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  CopyTagsFromSource = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceSpecification}{Object. The instance to specify which volumes should be included in the snapshots.}

\item{Description}{String.  A description propagated to every snapshot specified by the instance.[optional]}

\item{OutpostArn}{String.   The Amazon Resource Name (ARN) of the AWS Outpost on which to create the local snapshots.[optional]}

\item{TagSpecification}{List. Tags to apply to every snapshot specified by the instance.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{CopyTagsFromSource}{String. Copies the tags from the specified volume to corresponding snapshot.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Snapshots
}
\section{InstanceSpecification}{

The instance to specify
which volumes should be included in the snapshots.
}

\section{Description}{


A description propagated to every snapshot specified by the
instance.
}

\section{OutpostArn}{


The Amazon Resource Name (ARN) of the AWS Outpost on which to create the
local snapshots.
\itemize{
\item To create snapshots from an instance in a Region, omit this
parameter. The snapshots are created in the same Region as the
instance.
\item To create snapshots from an instance on an Outpost and store the
snapshots in the Region, omit this parameter. The snapshots are
created in the Region for the Outpost.
\item To create snapshots from an instance on an Outpost and store the
snapshots on an Outpost, specify the ARN of the destination Outpost.
The snapshots must be created on the same Outpost as the instance.
}

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot}{Creating multi-volume local snapshots from instances on an Outpost}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}

\section{TagSpecification}{

Tags to apply to every snapshot specified by the
instance.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{CopyTagsFromSource}{

Copies the tags from the
specified volume to corresponding snapshot.
}

