% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{aweSOMdendrogram}
\alias{aweSOMdendrogram}
\title{Dendogram of hierarchical clustering of SOM cells}
\usage{
aweSOMdendrogram(clust, nclass)
}
\arguments{
\item{clust}{an object of class \code{hclust}, the result of a hierarchical
clustering performed by \code{stats::hclust}.}

\item{nclass}{an integer, number of superclasses}
}
\value{
Returns \code{NULL} if \code{nclass} is 1, or else a \code{list}
  containing the indices of the SOM cells in each superclass.
}
\description{
Plots the dendogram of a hierarchical clustering of the SOM prototypes.
}
\examples{
## Build training data
dat <- iris[, c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")]
### Scale training data
dat <- scale(dat)
## Train SOM
### Initialization (PCA grid)
init <- somInit(dat, 4, 4)
ok.som <- kohonen::som(dat, grid = kohonen::somgrid(4, 4, 'hexagonal'),
                       rlen = 100, alpha = c(0.05, 0.01),
                       radius = c(2.65,-2.65),
                       init = init, dist.fcts = 'sumofsquares')
## Group cells into superclasses (hierarchical clustering)
superclust <- hclust(dist(ok.som$codes[[1]]), 'complete')
## Plot superclasses dendrogram
aweSOMdendrogram(superclust, 2)
}
