% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/run_var.r
\name{run_var}
\alias{run_var}
\title{Calculate the VAR model and apply restrictions}
\usage{
run_var(endo_matrix, exo_matrix, lag)
}
\arguments{
\item{endo_matrix}{A numeric matrix of endogenous data.}

\item{exo_matrix}{Either \code{NULL} or a numeric matrix of exogenous data.}

\item{lag}{A nonnegative integer specifying the lag length of the model. Specifying 0 for the lag results in calculating a lag 1 model with all lag-1 terms restricted.}
}
\value{
A \code{varest} object with the VAR estimation result.
}
\description{
This function calls the \code{vars::var} function to calculate the VAR model and applies restrictions if needed. We set the intercept to 1 for restricted equations because calculations go wrong otherwise (this is a bug in the vars library).
}
\examples{
endo_matrix <- matrix(rnorm(120), ncol = 2, nrow = 60,
                      dimnames = list(NULL, c("rumination", "activity")))
autovarCore:::run_var(endo_matrix, NULL, 1)
}

