% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_detect_cycle.R
\name{stsm_detect_cycle}
\alias{stsm_detect_cycle}
\title{Detect cycle from the data}
\usage{
stsm_detect_cycle(y, freq, sig_level = 1e-04, prior = NULL)
}
\arguments{
\item{y}{Univariate time series of data values.}

\item{freq}{Frequency of the data (1 (yearly), 4 (quarterly), 12 (monthly), 365.25/7 (weekly), 365.25 (daily))}

\item{sig_level}{Significance level to determine statistically significant seasonal frequencies}

\item{prior}{A data table created by stsm_prior}
}
\value{
Numeric value of cycle periodicity
}
\description{
Detect cycle from the data
}
\examples{
\dontrun{
#GDP Not seasonally adjusted
library(autostsm)
data("NA000334Q", package = "autostsm") #From FRED
NA000334Q = data.table(NA000334Q, keep.rownames = TRUE)
colnames(NA000334Q) = c("date", "y")
NA000334Q[, "date" := as.Date(date)]
NA000334Q[, "y" := as.numeric(y)]
NA000334Q = NA000334Q[date >= "1990-01-01", ]
cycle = stsm_detect_cycle(y = NA000334Q$y, freq = 4)
}
}
