% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_ae_slide.R
\name{t_ae_slide}
\alias{t_ae_slide}
\title{Adverse event table}
\usage{
t_ae_slide(
  adsl,
  adae,
  arm = "TRT01A",
  split_by_study = FALSE,
  side_by_side = NULL
)
}
\arguments{
\item{adsl}{ADSL data set, dataframe}

\item{adae}{ADAE data set, dataframe}

\item{arm}{Arm variable, character, "`TRT01A" by default.}

\item{split_by_study}{Split by study, building structured header for tables}

\item{side_by_side}{should table be displayed side by side}
}
\value{
rtables object
}
\description{
Adverse event table
}
\note{
* Default arm variables are set to `"TRT01A"` for safety output, and
 `"TRT01P"` for efficacy output
}
\examples{
library(dplyr)
adsl <- eg_adsl \%>\%
  dplyr::mutate(TRT01A = factor(TRT01A, levels = c("A: Drug X", "B: Placebo")))
adae <- eg_adae \%>\%
  dplyr::mutate(
    TRT01A = factor(TRT01A, levels = c("A: Drug X", "B: Placebo")),
    ATOXGR = AETOXGR
  )
out <- t_ae_slide(adsl, adae, "TRT01A")
print(out)
generate_slides(out, paste0(tempdir(), "/ae.pptx"))
}
