% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_get_changes_added}
\alias{am_get_changes_added}
\title{Get changes in one document that are not in another}
\usage{
am_get_changes_added(doc1, doc2)
}
\arguments{
\item{doc1}{An Automerge document (base/reference document)}

\item{doc2}{An Automerge document (comparison document)}
}
\value{
A list of raw vectors, where each vector is a serialized change
that exists in \code{doc2} but not in \code{doc1}. Returns an empty list if
\code{doc1} already contains all changes from \code{doc2}.
}
\description{
Compares two documents and returns the changes that exist in \code{doc2}
but not in \code{doc1}. This is useful for determining what changes need to be
applied to bring \code{doc1} up to date with \code{doc2}, or for implementing
custom synchronization logic.
}
\examples{
# Create two independent documents
doc1 <- am_create()
doc1$x <- 1
am_commit(doc1, "Add x")

doc2 <- am_create()
doc2$y <- 2
am_commit(doc2, "Add y")

# Find changes in doc2 that aren't in doc1
changes <- am_get_changes_added(doc1, doc2)
length(changes)  # 1 change

# Apply those changes to doc1
am_apply_changes(doc1, changes)

# Now doc1 has both x and y
names(doc1)  # "x" "y"

am_close(doc1)
am_close(doc2)

}
