% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_apply_changes}
\alias{am_apply_changes}
\title{Apply changes to a document}
\usage{
am_apply_changes(doc, changes)
}
\arguments{
\item{doc}{An Automerge document}

\item{changes}{A list of raw vectors (serialized changes) from \code{am_get_changes()}}
}
\value{
The document \code{doc} (invisibly, for chaining)
}
\description{
Applies a list of changes (obtained from \code{am_get_changes()}) to a document.
This is useful for manually syncing changes or for applying changes received
over a custom network protocol.
}
\examples{
# Create two documents
doc1 <- am_create()
doc2 <- am_create()

# Make changes in doc1
am_put(doc1, AM_ROOT, "x", 1)
am_commit(doc1)

# Get changes and apply to doc2
changes <- am_get_changes(doc1, NULL)
am_apply_changes(doc2, changes)

# Now doc2 has the same data as doc1
}
