% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rep_woe.R
\name{rep_woe}
\alias{rep_woe}
\title{Replace Feature Data by Binning Template}
\usage{
rep_woe(df, key_var, y_var, tool, var_label, col_woe, lower, upper)
}
\arguments{
\item{df}{A data.frame with independent variables and target variable.}

\item{key_var}{A name of index variable name.}

\item{y_var}{A name of target variable.}

\item{tool}{Binning template.}

\item{var_label}{The name of the characteristic variable.}

\item{col_woe}{The name of the woe variable}

\item{lower}{The name of the binning lower bound.}

\item{upper}{The name of the binning upper bound.}
}
\value{
A data frame of woe
}
\description{
Replace Feature Data by Binning Template
}
\examples{
accepts <- read.csv( system.file( "extdata", "accepts.csv", package ="autoScorecard" ))
feature <- stats::na.omit( accepts[,c(1,3,7:23)] )
all2 <- bins_tree( df = feature, key_var = "application_id", y_var = "bad_ind",
max_depth = 3, p= 0.1)
re2 <- rep_woe(  df= feature ,key_var = "application_id", y_var = "bad_ind",
tool = all2, var_label = "variable",col_woe ='woe', lower ='lower',upper ='upper')
}
