% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gene_lists.R
\name{read_gene_lists}
\alias{read_gene_lists}
\title{Read all the genes lists}
\usage{
read_gene_lists(
  gene_lists_path = "./results",
  log2FC_threshold = 0,
  padj_threshold = 0.05,
  which_list = c("up_genes", "down_genes", "up_down_genes", "everything"),
  from_autoGO = TRUE,
  files_format = NULL
)
}
\arguments{
\item{gene_lists_path}{Specify the full path to the folder where the gene lists have to read from (all fitting files in any subdirectory will be loaded).}

\item{log2FC_threshold}{Threshold value for log2(Fold Change) for considering genes as differentially expressed (default = 0).}

\item{padj_threshold}{Threshold value for adjusted p-value significance (Defaults to 0.05).}

\item{which_list}{It can be: "up_genes","down_genes","up_down_genes","everything". Select a list of genes to perform the enrichment. Respectively, both up and down regulated genes (up_down_genes), only up regulated genes (up_genes), only down regulated genes (down_genes), or (everything) allow to load all the three kind of lists separately and it is employed also for lists not from differential analysis..}

\item{from_autoGO}{Default is TRUE, set FALSE if the gene list you want to upload are not from a differential expression analysis.}

\item{files_format}{(Default = NULL). When from_autoGO = FALSE it is mandatory to provide the extension of the list of genes to upload.}
}
\value{
List of gene lists, each one being a one-dimensional data.frame.
}
\description{
Function employed for reading all the gene lists on which the enrichment will be performed.
}
\examples{
\dontrun{
gene_lists <- read_gene_lists(
  gene_lists_path = "./results",
  log2FC_threshold = 0,
  padj_threshold = 0.05,
  which_list = "down_genes",
  from_autoGO = T,
  files_format = NULL
)
}
}
