% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-year.r
\name{auk_year}
\alias{auk_year}
\title{Filter the eBird data to a set of years}
\usage{
auk_year(x, year, replace = FALSE)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{year}{integer; years to filter to.}

\item{replace}{logical; multiple calls to \code{auk_year()} are additive,
unless \code{replace = FALSE}, in which case the previous list of years to
filter by will be removed and replaced by that in the current call.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a set of
years. This function only defines the filter and, once all filters have
been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and perform the
filtering.
}
\details{
For filtering to a range of dates use \code{auk_date()}; however,
sometimes the goal is to extract data for a given year or set of years, in
which case \code{auk_year()} is simpler. In addition, \code{auk_year()} can be used
to get data from discontiguous sets of years (e.g. 2010 and 2012, but not
2011), which is not possible with \code{auk_date()}. Finally, \code{auk_year()} can
be used in conjunction with \code{auk_date()} to extract data from a given range
of dates within a set of years (see example below).

This function can also work with on an \code{auk_sampling} object if the user
only wishes to filter the sampling event data.
}
\examples{
# years to filter to
years <- c(2010, 2012)
# set up filter
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_year(year = years)
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_year(ebd, years)

# filter to may and june of 2010 and 2012
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_year(year = c(2010, 2012)) \%>\% 
  auk_date(date = c("*-05-01", "*-06-30"))
}
\seealso{
Other filter: 
\code{\link{auk_bbox}()},
\code{\link{auk_bcr}()},
\code{\link{auk_breeding}()},
\code{\link{auk_complete}()},
\code{\link{auk_country}()},
\code{\link{auk_county}()},
\code{\link{auk_date}()},
\code{\link{auk_distance}()},
\code{\link{auk_duration}()},
\code{\link{auk_extent}()},
\code{\link{auk_filter}()},
\code{\link{auk_last_edited}()},
\code{\link{auk_observer}()},
\code{\link{auk_project}()},
\code{\link{auk_protocol}()},
\code{\link{auk_species}()},
\code{\link{auk_state}()},
\code{\link{auk_time}()}
}
\concept{filter}
