% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attrCUSUM_getxxx_and_utils.R
\name{getContl}
\alias{getContl}
\title{Compute Control Limits for Attribute FSI CUSUM Chart}
\usage{
getContl(anss.target = 370.4, refv, c.zero = 0, process, maxndec = 7L,
  maxnumsubI = 6000L)
}
\arguments{
\item{anss.target}{A predetermined in-control ANSS/ARL (\eqn{\le}50000L),
default is 370.4.}

\item{refv}{A reference value of CUSUM statistic.}

\item{c.zero}{An initial state of CUSUM statistic (default is 0).}

\item{process}{An object of function
standing for pmf of count process of interest. See 'Details'.}

\item{maxndec}{The maximum number of decimal places
of \code{refv} (\eqn{\le} 7L).}

\item{maxnumsubI}{The maximum number of sub-intervals in [100,6000] to be used in
applying the Markov chain approach.}
}
\value{
A list including followings:
   \item{refv.act}{A reference value of CUSUM statistic used actually for
     computation.}
   \item{c.zero.act}{An initial state of CUSUM statistic used actually for
     computation.}
   \item{sol1,sol2}{Vector of control limits and corresponding ANSS/ARLs}
}
\description{
Computation of suitable control limits
   for attribute FSI-CUSUM control chart for mean increase
   based on specified reference value and in-control ANSS/ARL.
}
\details{
For CUSUM control chart for detecting mean increase,
   the CUSUM statistic \eqn{(C_{t})} are defined as following:
   \deqn{C_{t}=max(C_{t-1}, 0) + X_{t} - k,    t=1,2,...,}
   wherein \eqn{X_{t}} is a count process of interest,
   \eqn{k} is the reference value and \eqn{C_{0}} is the initial state.

   The argument \code{process} is an object of function such that
   for given integer-valued vector \code{x},
   \code{process(x)} returns \eqn{P(X=x)}
   where \eqn{X} is a random variable of interest.

   If the number of sub-intervals
   for transient states of Markov chain is greater than \code{maxnsubI},
   it will be set to be a suitable value
   being less than or equal \code{maxnsubI}.

   Invalid arguments rise an error with a helpful message.

   This function currently provides only the case for monitoring of mean increase.
   We leave other issues as our future work.
}
\examples{
# Example 1: Poisson distribution
getContl(anss.target = 200, refv = 5, c.zero = 0,
         process = function(x) dpois(x, lambda = 4))
}
\references{
Reynolds et al. (1990).
   CUSUM Charts with Variable Sampling Intervals,
   \emph{Technometrics}, 32(4), 371-384.
}
\seealso{
\code{\link{getAve}}.
}

