% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series_tags.R
\name{get_series_tags}
\alias{get_series_tags}
\title{Get unique series tags for the metric.}
\usage{
get_series_tags(metric, entity = NA, verbose = TRUE)
}
\arguments{
\item{metric}{Required string argument.
The name of the metric you want to get data for. 
For example, \code{metric = "disk_used_percent"}.
\cr
To obtain a list of metrics collected by ATSD use the
\code{\link{get_metrics}} function.}

\item{entity}{Optional string argument. 
The name of the entity you want to get data for.
If not provided, then data for all entities will be fetched
for the specified metric.
Obtain the list of entities and their tags with the
\code{\link{get_entities}} function.}

\item{verbose}{Optional boolean argument.
If \code{verbose = FALSE} then all console output will be suppressed.
By default, \code{verbose = TRUE}.}
}
\value{
A data frame. 
    Each row of the data frame corresponds to a time series,
    and contains the series unique tags, and last time the series was updated.
    For more information view the package vignette: 
    \code{browseVignettes(package = "atsd")}.
}
\description{
The function determines time series collected for a given metric.
For each time series it lists tags associated with the series,
and last time the series was updated. 
The list of fetched time series is based on data stored on disk 
for the last 24 hours.
}
\examples{
\dontrun{
# get all time series and their tags collected by ATSD for the "disk_used_percent" metric
get_series_tags(metric = "disk_used_percent")

# get all time series and their tags for the "disk_used_percent" metric
# end "nurswgvml007" entity
get_series_tags(metric = "disk_used_percent", entity = "nurswgvml007")
}
}
