% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed.r
\name{post}
\alias{post}
\alias{post_skeet}
\alias{delete_skeet}
\alias{delete_post}
\title{Post a skeet}
\usage{
post(
  text,
  in_reply_to = NULL,
  quote = NULL,
  image = NULL,
  image_alt = NULL,
  video = NULL,
  created_at = Sys.time(),
  labels = NULL,
  langs = NULL,
  tags = NULL,
  preview_card = TRUE,
  verbose = NULL,
  .token = NULL
)

post_skeet(
  text,
  in_reply_to = NULL,
  quote = NULL,
  image = NULL,
  image_alt = NULL,
  video = NULL,
  created_at = Sys.time(),
  labels = NULL,
  langs = NULL,
  tags = NULL,
  preview_card = TRUE,
  verbose = NULL,
  .token = NULL
)

delete_skeet(post_url, verbose = NULL, .token = NULL)

delete_post(post_url, verbose = NULL, .token = NULL)
}
\arguments{
\item{text}{Text to post}

\item{in_reply_to}{URL or URI of a skeet this should reply to.}

\item{quote}{URL or URI of a skeet this should quote.}

\item{image, video}{path to an image or video to post.}

\item{image_alt}{alt text for the image.}

\item{created_at}{time stamp of the post.}

\item{labels}{can be used to label a post, for example "!no-unauthenticated",
"porn", "sexual", "nudity", or "graphic-media".}

\item{langs}{indicates human language(s) (up to 3) of post's primary text
content.}

\item{tags}{additional hashtags, in addition to any included in post text and
facets.}

\item{preview_card}{display a preview card for links included in the text
(only if image is \code{NULL}).}

\item{verbose}{Whether to print status messages to the Console
(\code{TRUE}/\code{FALSE}). Package default (when \code{NULL}) is to have
status messages. Can be changed with \code{Sys.setenv(ATR_VERBOSE =
  FALSE)}.}

\item{.token}{If you manage your own tokens, you can supply it here. Usually
\code{NULL} is OK and will automatically load or guide you to generate a
token.}

\item{post_url}{URL or URI of post to delete.}
}
\value{
list of the URI and CID of the post (invisible)
}
\description{
Post a skeet
}
\examples{
\dontrun{
post("Hello from #rstats with {atrrr}")
}
}
