% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists.r
\name{get_list}
\alias{get_list}
\alias{get_list_feed}
\title{Get List}
\usage{
get_list(
  list,
  limit = 25,
  cursor = NULL,
  parse = TRUE,
  verbose = NULL,
  .token = NULL
)

get_list_feed(
  list,
  limit = 25,
  cursor = NULL,
  parse = TRUE,
  verbose = NULL,
  .token = NULL
)
}
\arguments{
\item{list}{The url of the requested list}

\item{limit}{Maximum number of records to return. For queries with more than
100 results, pagination is used automatically (one request per 100
results). The function stops when the limit is reached, but you will
usually get a few items more than requested.}

\item{cursor}{Cursor for pagination (to pick up an old search).}

\item{parse}{Parse the results or return the original nested object sent by
the server.}

\item{verbose}{Whether to print status messages to the Console
(\code{TRUE}/\code{FALSE}). Package default (when \code{NULL}) is to have
status messages. Can be changed with \code{Sys.setenv(ATR_VERBOSE =
  FALSE)}.}

\item{.token}{If you manage your own tokens, you can supply it here. Usually
\code{NULL} is OK and will automatically load or guide you to generate a
token.}
}
\value{
a data frame (or nested list) of posts
}
\description{
Get a feed of recent posts from a list (posts and reposts from any actors on
the list).
}
\examples{
\dontrun{
# use the URL of a list to get users on the list
get_list("https://bsky.app/profile/smachlis.bsky.social/lists/3l7o5d7b7nl2q")

# or the feed of that list
get_list_feed("https://bsky.app/profile/smachlis.bsky.social/lists/3l7o5d7b7nl2q")
}
}
