% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed.r
\name{get_likes}
\alias{get_likes}
\alias{get_reposts}
\title{Get likes/reposts of a skeet}
\usage{
get_likes(
  post_url,
  limit = 25L,
  cursor = NULL,
  parse = TRUE,
  verbose = NULL,
  .token = NULL
)

get_reposts(
  post_url,
  limit = 25L,
  cursor = NULL,
  parse = TRUE,
  verbose = NULL,
  .token = NULL
)
}
\arguments{
\item{post_url}{the URL of a skeet for which to retrieve who liked/reposted it.}

\item{limit}{Maximum number of records to return. For queries with more than
100 results, pagination is used automatically (one request per 100
results). The function stops when the limit is reached, but you will
usually get a few items more than requested.}

\item{cursor}{Cursor for pagination (to pick up an old search).}

\item{parse}{Parse the results or return the original nested object sent by
the server.}

\item{verbose}{Whether to print status messages to the Console
(\code{TRUE}/\code{FALSE}). Package default (when \code{NULL}) is to have
status messages. Can be changed with \code{Sys.setenv(ATR_VERBOSE =
  FALSE)}.}

\item{.token}{If you manage your own tokens, you can supply it here. Usually
\code{NULL} is OK and will automatically load or guide you to generate a
token.}
}
\value{
a data frame (or nested list) of likes/reposts
}
\description{
Get likes/reposts of a skeet
}
\examples{
\dontrun{
get_likes("https://bsky.app/profile/jbgruber.bsky.social/post/3kbi55xm6u62v")
get_reposts("https://bsky.app/profile/jbgruber.bsky.social/post/3kbi55xm6u62v")
}
}
