% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-fgs.R
\name{load_fgs}
\alias{load_fgs}
\title{Load the functional group file}
\usage{
load_fgs(fgs)
}
\arguments{
\item{fgs}{Character string giving the connection to the functional groups file.
The filename usually contains \code{Groups} and does end in \code{.csv}.}
}
\value{
A \code{data.frame} of functional group information.
}
\description{
Read in the functional group file as dataframe.
}
\examples{
d <- system.file("extdata", "setas-model-new-becdev", package = "atlantistools")
file <- "SETasGroups.csv"
fgs <- load_fgs(file.path(d, file))
head(fgs)

d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
file <- "SETasGroupsDem_NoCep.csv"
fgs <- load_fgs(file.path(d, file))
head(fgs)
}
\seealso{
Other load functions: \code{\link{load_box}},
  \code{\link{load_bps}}, \code{\link{load_dietcheck}},
  \code{\link{load_init_age}}, \code{\link{load_init}},
  \code{\link{load_nc_physics}}, \code{\link{load_nc}},
  \code{\link{load_rec}}, \code{\link{load_spec_mort}},
  \code{\link{load_txt}}
}
