% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_statistics.R
\name{format_statistics}
\alias{format_statistics}
\alias{format_statistics.statistics_numeric}
\alias{format_statistics.statistics_factor}
\alias{format_statistics.statistics_count_me}
\alias{format_statistics.default}
\title{Format statistics}
\usage{
format_statistics(x, ...)

\method{format_statistics}{statistics_numeric}(x,
  format_statistics.statistics_numeric = NULL, ...)

\method{format_statistics}{statistics_factor}(x,
  format_statistics.statistics_factor = NULL, ...)

\method{format_statistics}{statistics_count_me}(x, ...)

\method{format_statistics}{default}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Passed from and to other methods.}

\item{format_statistics.statistics_numeric}{Either \code{NULL} or a function. Default is \code{NULL}.
If a function, then it will replace \code{atable:::format_statistics.statistics_numeric}.
The function must mimic \code{\link{format_statistics}}: arguments are \code{x} and the ellipsis ... .
Result is a non-empty data.frame with 2 columns called \code{'tag'} and \code{'value'}.}

\item{format_statistics.statistics_factor}{Analog to argument format_statistics.statistics_numeric}
}
\value{
A non-empty data.frame with 2 columns called \code{'tag'} and \code{'value'}.
Column \code{'tag'} has class factor and no duplicates.
Column \code{'value'} is a character.
See also function \code{\link{check_format_statistics}}.
}
\description{
The results of function \code{statistics} must be formated before printing. \code{format_statistics} does this.
}
\details{
This function defines which statistics are printed in the final table and how they are formated.

The format depends on the class \code{x}. See section methods.

If you are not pleased with the current format you may alter these functions.
But you must keep the original output-format, see section Value.
Function \code{\link{check_format_statistics}} checks if the output of statistics is suitable for further processing.
}
\section{Methods (by class)}{
\itemize{
\item \code{statistics_numeric}: Defines how to format class \code{statistics_numeric}.
Returns a data.frame with 2 rows.
Column \code{'tag'} contains \code{'Mean_SD'} and \code{'valid_missing'}.
Column \code{'value'} contains two values: first value is the rounded mean and standard deviation, pasted them together. The standard deviation is bracketed.
Second value is the number of non-missing and missing values pasted together. The number of missing values is bracketed.

\item \code{statistics_factor}: Defines how to format class \code{statistics_factor}.
Returns a data.frame.
Column \code{'tag'} contains all names of \code{x}.
Column \code{'value'} contains the percentages and the total number of values in brackets.

\item \code{statistics_count_me}: Defines how to format class \code{statistics_count_me}.
Returns a data.frame.
Column \code{'tag'} contains the empty character \code{''}.
The empty character is choosen because \code{colname_for_observations} already appears in the final table.
Column \code{'value'} contains the number of observations.
See also \code{'colname_for_observations'} in \code{\link{atable_options}}.

\item \code{default}: Returns a data.frame.
Column \code{'tag'} contains all names of \code{x}.
Column \code{'value'} contains all elements of \code{x}, rounded by \code{\link[base]{format}}.
}}

