% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R, R/deprecated_se.R
\name{insist}
\alias{insist}
\alias{insist_}
\title{Raises error if dynamically created predicate is FALSE in any columns selected}
\usage{
insist(data, predicate_generator, ..., success_fun = success_continue,
  error_fun = error_stop)

insist_(data, predicate_generator, ..., .dots, success_fun = success_continue,
  error_fun = error_stop)
}
\arguments{
\item{data}{A data frame}

\item{predicate_generator}{A function that is applied
to each of the column vectors selected. This will produce,
for every column, a true predicate function to be applied to
every element in the column vectors selected}

\item{...}{Comma separated list of unquoted expressions.
Uses dplyr's \code{select} to select
columns from data.}

\item{success_fun}{Function to call if assertion passes. Defaults to
returning \code{data}.}

\item{error_fun}{Function to call if assertion fails. Defaults to printing
a summary of all errors.}

\item{.dots}{Use insist_() to select columns using standard evaluation.}
}
\value{
By default, the \code{data} is returned if dynamically created
        predicate assertion is TRUE and and error is thrown if not. If a
        non-default \code{success_fun} or \code{error_fun} is used, the
        return values of these function will be returned.
}
\description{
Meant for use in a data analysis pipeline, this function applies a predicate
generating function to each of the columns indicated. It will then use these
predicates to check every element of those columns. If any of these
predicate applications yield FALSE, this function will raise an error,
effectively terminating the pipeline early. If there are no FALSES, this
function will just return the data that it was supplied for further use in
later parts of the pipeline.
}
\details{
For examples of possible choices for the \code{success_fun} and
\code{error_fun} parameters, run \code{help("success_and_error_functions")}
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{

insist(iris, within_n_sds(3), Sepal.Length)   # returns iris

library(magrittr)

iris \%>\%
  insist(within_n_sds(4), Sepal.Length:Petal.Width)
  # anything here will run

\dontrun{
iris \%>\%
  insist(within_n_sds(3), Sepal.Length:Petal.Width)
  # datum at index 16 of 'Sepal.Width' vector is (4.4)
  # is outside 3 standard deviations from the mean of Sepal.Width.
  # The check fails, raises a fatal error, and the pipeline
  # is terminated so nothing after this statement will run}

}
\seealso{
\code{\link{assert}} \code{\link{verify}} \code{\link{insist_rows}}
         \code{\link{assert_rows}}
}
