% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assert-is-na-nan-null.R, R/is-na-nan-null.R
\name{assert_is_not_null}
\alias{assert_is_not_null}
\alias{assert_is_null}
\alias{is_null}
\title{Is the input (not) null?}
\usage{
assert_is_not_null(x)

assert_is_null(x)

is_null(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_null} wraps \code{is.null}, providing more
information on failure. \code{is_not_null} returns \code{TRUE} in
the opposite case.  The \code{assert_*} functions return nothing but
throw an error if the corresponding \code{is_*} function returns
\code{FALSE}.
}
\description{
Checks to see if the input is (not) null.
}
\examples{
assert_is_null(NULL)
assert_is_null(c())
assert_is_not_null(NA)
}
\seealso{
\code{\link[base]{is.null}}.
}

