% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-formula.R, R/is-formula.R
\name{assert_is_formula}
\alias{assert_is_formula}
\alias{assert_is_one_sided_formula}
\alias{assert_is_two_sided_formula}
\alias{is_formula}
\alias{is_one_sided_formula}
\alias{is_two_sided_formula}
\title{Is the input a formula?}
\usage{
assert_is_formula(x, severity = getOption("assertive.severity", "stop"))

assert_is_one_sided_formula(x, severity = getOption("assertive.severity",
  "stop"))

assert_is_two_sided_formula(x, severity = getOption("assertive.severity",
  "stop"))

is_formula(x, .xname = get_name_in_parent(x))

is_one_sided_formula(x, .xname = get_name_in_parent(x))

is_two_sided_formula(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
The \code{is_*} functions return \code{TRUE} when the input is a 
formula.  The \code{assert_*} functions return nothing but throw an error 
if the corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the input is a formula.
}
\examples{
is_one_sided_formula(~ x)
is_two_sided_formula(y ~ x)
}
\seealso{
\code{\link{is_environment}} and  \code{\link{is_language}}
}

