% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-type-data.table.R, R/is-type-data.table.R
\name{assert_is_data.table}
\alias{assert_is_data.table}
\alias{is_data.table}
\title{Is the input a data.table?}
\usage{
assert_is_data.table(x, severity = getOption("assertive.severity", "stop"))

is_data.table(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_data.table} wraps \code{is.data.table}, providing more 
information on failure. The \code{assert_*} functions return nothing but
throws an error if the corresponding \code{is_*} function returns 
\code{FALSE}.
}
\description{
Checks to see if the input is a data.table.
}
\examples{
if(requireNamespace("data.table"))
{
  assert_is_data.table(data.table::data.table(x = 1:5))
  #These examples should fail.
  assertive.base::dont_stop(assert_is_data.table(list(1,2,3)))
} else
{
  message("This example requires the data.table package to be installed.")
}
}
\seealso{
\code{\link[data.table]{is.data.table}}.
}

