% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-code.R, R/is-code.R
\name{assert_is_debugged}
\alias{assert_is_debugged}
\alias{is_debugged}
\title{Is the input function being debugged?}
\usage{
assert_is_debugged(x, severity = getOption("assertive.severity", "stop"))

is_debugged(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_debugged} wraps \code{\link[base]{isdebugged}}, providing
more information on failure.  \code{assert_is_debugged} returns nothing but
throws an error if \code{is_debugged} returns \code{FALSE}.
}
\description{
Checks to see if the input DLL (a.k.a. shared object) is loaded.
}
\seealso{
\code{\link[base]{isdebugged}}.
}

