% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{assertionError}
\alias{assertionError}
\alias{assertionMessage}
\alias{assertionWarning}
\title{Condition classes}
\usage{
assertionError(message, call = NULL)

assertionWarning(message, call = NULL)

assertionMessage(message, call = NULL)
}
\arguments{
\item{message}{A string describing the problem.}

\item{call}{A call describing the source of the condition.}
}
\value{
An object of class \code{assertionError}, \code{assertionWarning}, or
\code{assertionMessage}.
}
\description{
Error, warning, and message classes derived from their simple equivalents.
}
\note{
These objects behave the same as the standard-issue \code{simpleError},
\code{simpleWarning}, and \code{simpleMessage} objects from base-R.  The
extra class allows you to provide custom handling for assertions inside 
\code{tryCatch}.
}
\examples{
tryCatch(
  assert_all_are_true(FALSE), 
  error = function(e) 
  {
    if(inherits(e, "assertionCondition"))
    {
      # Handle assertions
      message("This is an assertion condition.")
    } else
    {
      # Handle other error types
    }
  }
)
}

