% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observation.R
\name{obs_combined}
\alias{obs_combined}
\title{Observation with combined error}
\usage{
obs_combined(prediction, name, var_prop = 0.1, var_add = 1)
}
\arguments{
\item{prediction}{A definition of the model prediction}

\item{name}{A name for the observation (automatically derived if missing)}

\item{var_prop}{Variance of the proportional error component}

\item{var_add}{Variance of the additive error component}
}
\value{
A building block of type 'observation'
}
\description{
This building block declares an observation model with a combined residual error model (\eqn{y = f + f \epsilon_1 + \epsilon_2}).
}
\details{
Observation models specify the observed variable, how an observation is
expected to diverge from the model (i.e, the residual unexplained
variability model), and parameter values. The observation model type is
selected through the function name. The observed variable as well as the
parameters are specified as function arguments.
\subsection{Specifying predictions}{

The actual prediction from the model is the first argument of the
function. It can be specified in a number of different ways:
\itemize{
\item A name of a variable in the model: \code{obs_additive("effect")}
\item A compartment concentration: \code{obs_additive(~C["central"])}
\item An equation: \code{obs_additive(~base+slp*time)}
}

If the definition contains a variable name on the left-hand side (as in
\code{conc~C["central"]}), the variable will appear in the generated model
code. This can be useful to make the model code more readable if the
prediction is defined as a long equation.
}

\subsection{Observation names}{

The observation name can be specified via the \verb{name=} argument and is
automatically derived if the argument is left empty. Adding an
observation model with an already existing name will replace the
previous definition.
}

\subsection{Error variance}{

The variance of the error components are specified via the \verb{var_add=}
and \verb{var_prop=} arguments of the function.
}
}
\examples{
# additve RUV model for observing the variable WT
m <- model() +
  prm_log_normal("wt") +
  obs_additive(~wt)

# EMAX dose-response model with proportional RUV
m2 <- model() +
  input_variable("dose") +
  prm_no_var("emax") +
  prm_no_var("ed50") +
  obs_proportional(effect~emax*dose/(ed50+dose))
}
\seealso{
Other observation models: 
\code{\link{obs_additive}()},
\code{\link{obs_proportional}()}
}
\concept{observation models}
