% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ash.R
\name{ash}
\alias{ash}
\title{Main Adaptive Shrinkage function}
\usage{
ash(betahat, sebetahat, mixcompdist = c("uniform", "halfuniform", "normal",
  "+uniform", "-uniform"), df = NULL, ...)
}
\arguments{
\item{betahat}{a p vector of estimates}

\item{sebetahat}{a p vector of corresponding standard errors}

\item{mixcompdist}{distribution of components in mixture
("uniform","halfuniform" or "normal"; "+uniform" or
"-uniform"), the default is "uniform". If you believe your
effects may be asymmetric, use "halfuniform". If you want to
allow only positive/negative effects use "+uniform"/"-uniform".
The use of "normal" is permitted only if df=NULL.}

\item{df}{appropriate degrees of freedom for (t) distribution of
betahat/sebetahat, default is NULL which is actually treated as
infinity (Gaussian)}

\item{...}{Further arguments to be passed to
\code{\link{ash.workhorse}}.}
}
\value{
ash returns an object of \code{\link[base]{class}} "ash", a list with some or all of the following elements (determined by outputlevel) \cr
\item{fitted_g}{fitted mixture}
\item{loglik}{log P(D|fitted_g)}
\item{logLR}{log[P(D|fitted_g)/P(D|beta==0)]}
\item{result}{A dataframe whose columns are}
\describe{
 \item{NegativeProb}{A vector of posterior probability that beta is negative}
 \item{PositiveProb}{A vector of posterior probability that beta is positive}
 \item{lfsr}{A vector of estimated local false sign rate}
 \item{lfdr}{A vector of estimated local false discovery rate}
 \item{qvalue}{A vector of q values}
 \item{svalue}{A vector of s values}
 \item{PosteriorMean}{A vector consisting the posterior mean of beta from the mixture}
 \item{PosteriorSD}{A vector consisting the corresponding posterior standard deviation}
 }
\item{call}{a call in which all of the specified arguments are specified by their full names}
\item{data}{a list containing details of the data and models used (mostly for internal use)}
\item{fit_details}{a list containing results of mixture optimization, and matrix of component log-likelihoods used in this optimization}
}
\description{
Takes vectors of estimates (betahat) and their
    standard errors (sebetahat), together with degrees of freedom (df)
    and applies shrinkage to them, using Empirical Bayes methods, to compute shrunk estimates for
    beta.
}
\details{
This function is actually just a simple wrapper that
    passes its parameters to \code{\link{ash.workhorse}} which
    provides more documented options for advanced use. See readme
    for more details.
}
\examples{
beta = c(rep(0,100),rnorm(100))
sebetahat = abs(rnorm(200,0,1))
betahat = rnorm(200,beta,sebetahat)
beta.ash = ash(betahat, sebetahat)
names(beta.ash)
head(beta.ash$result) # the main dataframe of results
graphics::plot(betahat,beta.ash$result$PosteriorMean,xlim=c(-4,4),ylim=c(-4,4))

CIMatrix=ashci(beta.ash,level=0.95)
print(CIMatrix)

#Illustrating the non-zero mode feature
betahat=betahat+5
beta.ash = ash(betahat, sebetahat)
graphics::plot(betahat,beta.ash$result$PosteriorMean)
betan.ash=ash(betahat, sebetahat,mode=5)
graphics::plot(betahat, betan.ash$result$PosteriorMean)
summary(betan.ash)
}
\seealso{
\code{\link{ash.workhorse}} for complete specification of ash function

\code{\link{ashci}} for computation of credible intervals after getting the ash object return by \code{ash()}
}

