% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique.R
\name{unique}
\alias{unique}
\alias{unique,itemMatrix-method}
\alias{unique,associations-method}
\title{Remove Duplicated Elements from a Collection}
\usage{
unique(x, incomparables = FALSE, ...)

\S4method{unique}{itemMatrix}(x, incomparables = FALSE)

\S4method{unique}{associations}(x, incomparables = FALSE, ...)
}
\arguments{
\item{x}{an object of class \link{itemMatrix} or \link{associations}.}

\item{incomparables}{currently unused.}

\item{\dots}{further arguments (currently unused).}
}
\value{
An object of the same class as \code{x} with duplicated elements
removed.
}
\description{
Provides the generic function \code{unique()} and the methods for
\link{itemMatrix} \link{transactions}, and \link{associations}.
}
\details{
\code{unique()} uses \code{\link[=duplicated]{duplicated()}} to return an
object with the duplicate elements removed.
}
\examples{
data("Adult")

r1 <- apriori(Adult[1:1000], parameter = list(support = 0.5))
r2 <- apriori(Adult[1001:2000], parameter = list(support = 0.5))

## Note that this produces a collection of rules from two sets
r_comb <- c(r1, r2)
r_comb <- unique(r_comb)
r_comb
}
\seealso{
Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\concept{itemMatrix and transactions functions}
\keyword{manip}
