\name{is.superset}
\alias{is.subset}
\alias{is.subset,itemMatrix-method}
\alias{is.subset,associations-method}
\alias{is.superset}
\alias{is.superset,itemMatrix-method}
\alias{is.superset,associations-method}
%
%
\title{Find Super and Subsets}
\description{
  Provides the generic functions 
  and the S4 methods \code{is.subset} and \code{is.superset}
  for finding super or subsets in associations and itemMatrix objects.
}
\usage{
is.subset(x, y = NULL, proper = FALSE)
is.superset(x, y = NULL, proper = FALSE)
}
\arguments{
  \item{x, y}{ associations or itemMatrix objects. If \code{y = NULL}, 
    the super or subset structure within set \code{x} is calculated.}
  \item{proper}{\code{"logical"}; all or just proper super or subsets.}
}
\details{
looks for each element in \code{x} which 
elements in \code{y} are supersets  or subsets. Note that the method
can be very slow and memory intensive  
if \code{x} and/or \code{y} contain many elements.
}
\value{
returns a 
logical matrix with \code{length(x)} rows
and \code{length(y)} columns. 
Each logical row vector represents which elements in \code{y}
are supersets (subsets) of the corresponding element in \code{x}.
If either \code{x} or \code{y} have lenght zero, \code{NULL} is returned 
instead of a matrix.
}
\seealso{
  \code{\link{associations-class}},
  \code{\link{itemMatrix-class}}
}
\examples{
data("Adult")
set <- eclat(Adult, parameter = list(supp = 0.8))

### find the supersets of each itemset in set
is.superset(set, set)
}
\keyword{manip}
