% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/3_ComplexModels.R
\name{M_M_S_INF_H_Y}
\alias{M_M_S_INF_H_Y}
\title{Obtains the main characteristics of a M/M/s/\eqn{\infty}/H with Y replacements queueing model}
\usage{
M_M_S_INF_H_Y(lambda = 3, mu = 6, s = 3, h = 5, y = 3)
}
\arguments{
\item{lambda}{Mean arrival rate}

\item{mu}{Mean service rate}

\item{s}{Number of servers}

\item{h}{Population size}

\item{y}{Number of replacements}
}
\value{
Returns the next information of a M/M/s/\eqn{\infty}/H/Y model:
\item{rho}{Constant coefficient: \eqn{\lambda/\rho}}
\item{barrho}{Traffic intensity: \ifelse{latex}{\eqn{\bar{\rho}}}{\out{<i>&#862;&rho;</i>}}}
\item{barlambda}{Effective arrival rate: \ifelse{latex}{\eqn{\bar{\lambda}}}{\out{<i>&#862;&lambda;</i>}}}
\item{cn}{Coefficients used in the computation of \ifelse{latex}{\eqn{P_{n}}: \eqn{C_n}}{\out{P<sub>n</sub>: <i>C<sub>n</sub></i>}}}
\item{p0}{Probability of empty system: \ifelse{latex}{\eqn{P_{0}}}{\out{<i>P<sub>0</sub></i>}}}
\item{l}{Number of customers in the system: \eqn{L}}
\item{lq}{Number of customers in the queue: \ifelse{latex}{\eqn{L_q}}{\out{<i>L<sub>q</sub></i>}}}
\item{w}{Waiting time in the system: \eqn{W}}
\item{wq}{Waiting time in the queue: \ifelse{latex}{\eqn{W_q}}{\out{<i>W<sub>q</sub></i>}}}
\item{eff}{System efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_q)}}{\out{<i>Eff = W/(W-W<sub>q</sub></i>)}}}
}
\description{
Obtains the main characteristics of a M/M/s/\eqn{\infty}/H with Y replacements queueing model
}
\examples{
#A bank has 5 ATMs. Occasionally one ot them is
#damaged until one of the two hired technicians
#repairs it. It is known that the mean time to repair
#follows an exponential distribution with mean 10
#minutes, while the distribution of time an ATM
#is run until it breaks down it is also exponential
#with mean 2 hours. The bank has an ATM extra to
#replace a damaged one.

M_M_S_INF_H_Y(lambda=1/2, mu=60/10, s=2, h=5, y=1)
}
\seealso{
Other AnaliticalModels: \code{\link{ClosedJacksonNetwork}};
  \code{\link{M_M_1_INF_H}}; \code{\link{M_M_1_K}};
  \code{\link{M_M_1}}; \code{\link{M_M_INF}};
  \code{\link{M_M_S_INF_H}}; \code{\link{M_M_S_K}};
  \code{\link{M_M_S}}; \code{\link{OpenJacksonNetwork}}
}

