% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/5_SimulateModels.R
\name{G_G_S}
\alias{G_G_S}
\title{Obtains the main characteristics of a G/G/s model by simulation}
\usage{
G_G_S(arrivalDistribution = Exp(3), serviceDistribution = Exp(6), s = 2,
  staClients = 100, nClients = 1000, historic = FALSE, nsim = 10,
  nproc = 1)
}
\arguments{
\item{arrivalDistribution}{Arrival distribution (object of S4-class \code{distr}
defined in \pkg{distr} package)}

\item{serviceDistribution}{Service distribution (object of S4-class \code{distr}
defined in \pkg{distr} package)}

\item{s}{Number of servers}

\item{staClients}{Number of customers used in the stabilization stage}

\item{nClients}{Number of customers used in the simulation stage}

\item{historic}{Parameter used to activate/deactivate the historic information}

\item{nsim}{Number of simulations}

\item{nproc}{Processors used in the simulation.}
}
\value{
Returns the next information of a G/G/S model:
\item{pn}{vector of empirical steady-state probabilities of having n customers in the system: \ifelse{latex}{\eqn{P_{n}}}{\out{<i>P<sub>n</sub></i>}} (Only the probabilities bigger than 0 are included)}
\item{l}{Empirical number of customers in the system: \eqn{L}}
\item{lq}{Empirical number of customers in the queue: \ifelse{latex}{\eqn{L_{q}}}{\out{<i>L<sub>q</sub></i>}}}
\item{w}{Empirical waiting time in the system: \eqn{W}}
\item{wq}{Empirical waiting time in the queue: \ifelse{latex}{\eqn{W_{q}}}{\out{<i>W<sub>q</sub></i>}}}
\item{eff}{Empirical system efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_{q})}}{\out{<i>Eff = W/(W-W<sub>q</sub></i>)}}}
\item{rho}{Empirical Traffic intensity: \eqn{\rho}}
\item{historic}{Optional parameter that stores the evolution of \ifelse{latex}{\eqn{L}, \eqn{L_q}, \eqn{W} and  \eqn{W_q}}{\out{L, L<sub>q</sub>, W, W<sub>q</sub>}}\emph{, Customers in the system, Rho and Elapsed time} during the simulation}
}
\description{
Obtains the main characteristics of a G/G/s model by simulation
}
\examples{
G_G_S(Norm(10, 0.5), Unif(5,6), 2, staClients=10, nClients=100, nsim=10)
}
\seealso{
Other SimulatedModels: \code{\link{ClosedNetwork}};
  \code{\link{G_G_1_INF_H}}; \code{\link{G_G_1_K}};
  \code{\link{G_G_1}}; \code{\link{G_G_INF}};
  \code{\link{G_G_S_INF_H_Y}}; \code{\link{G_G_S_INF_H}};
  \code{\link{G_G_S_K}}; \code{\link{OpenNetwork}}
}

